package com.bycom.versapro.MenuTypes.WordPress.UserInterface;

import static com.bycom.versapro.MenuTypes.WordPress.UserInterface.WPPostFragment.TYPE_POSTS_BY_SEARCH;
import static com.bycom.versapro.Serializables.Constant.adMobHelper;
import static com.bycom.versapro.Utils.AppUtil.EdgeToEdgeEnable;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.speech.RecognizerIntent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.bycom.versapro.MenuTypes.WebView.WebViewFragment;
import com.bycom.versapro.R;
import java.util.ArrayList;

public class WPSearchActivity extends AppCompatActivity {


    EditText et_search;
    ImageView iv_left,iv_right;
    String BASE_URL;
    Boolean isFirstLaunch = true;



    private final ActivityResultLauncher<Intent> voiceRecognitionLauncher = registerForActivityResult(
            new ActivityResultContracts.StartActivityForResult(),
            result -> {
                if (result.getResultCode() == RESULT_OK && result.getData() != null) {
                    ArrayList<String> matches = result.getData().getStringArrayListExtra(RecognizerIntent.EXTRA_RESULTS);
                    if (matches != null && !matches.isEmpty()) {
                        String recognizedText = matches.get(0);
                        if(et_search != null) {
                            et_search.setText(recognizedText);
                            performSearch(recognizedText.trim());
                        }
                    }
                }
            });;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_wp_search);
        EdgeToEdgeEnable(this,findViewById(R.id.main));

        BASE_URL = getIntent().getStringExtra("BASE_URL");


        et_search = findViewById(R.id.et_search);

        iv_left = findViewById(R.id.iv_left);

        iv_right = findViewById(R.id.iv_right);

        iv_right.setOnClickListener(v -> {
            if(et_search.getText().toString().isEmpty()) {
                Intent intent = new Intent(RecognizerIntent.ACTION_RECOGNIZE_SPEECH);
                try {
                    voiceRecognitionLauncher.launch(intent);
                } catch (Exception e) {
                    Toast.makeText(WPSearchActivity.this, "Voice recognition not supported on your device", Toast.LENGTH_SHORT).show();
                }
            }else {
                et_search.setText("");
                toggleKeyboard(et_search,true);
            }
        });


        et_search.setOnEditorActionListener((v, actionId, event) -> {
            if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                String query = et_search.getText().toString().trim();
                if (!query.isEmpty()) {
                    performSearch(query);
                    toggleKeyboard(et_search,false);
                }else et_search.setError("Enter a search query");

                return true;
            }
            return false;
        });

        et_search.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                // Called before the text is changed. You can handle actions here if needed.
            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                // Called when the text is being changed. `s` is the updated text.

            }

            @Override
            public void afterTextChanged(Editable s) {

                if(!s.toString().isEmpty()) iv_right.setImageResource(R.drawable.ic_cross);
                else iv_right.setImageResource(R.drawable.ic_mic);
            }
        });

        adMobHelper.getInterstitialAdManager().showAd(this);



    }




    @Override
    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            if(isFirstLaunch) {
                isFirstLaunch = false;
                toggleKeyboard(et_search,true);
            }
        }
    }




    public void toggleKeyboard(View view, boolean showKeyboard) {
        InputMethodManager inputMethodManager = (InputMethodManager) view.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        if (inputMethodManager != null) {
            if (showKeyboard) {
                view.requestFocus();
                inputMethodManager.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT);
            } else {
                inputMethodManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
    }

    private void performSearch(String query) {
        et_search.clearFocus();
        getSupportFragmentManager().popBackStack(null, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        WPPostFragment wordPressFragment = new WPPostFragment();
        Bundle bundle = new Bundle();
        bundle.putInt("TYPE",TYPE_POSTS_BY_SEARCH);
        bundle.putString("BASE_URL",BASE_URL);
        bundle.putString("SEARCH_QUERY",query);
        wordPressFragment.setArguments(bundle);
        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        transaction.replace(R.id.container, wordPressFragment);
        transaction.commit();
    }

    @Override
    public void onBackPressed(){

        Fragment fragment = getSupportFragmentManager().findFragmentById(R.id.container);

        if(fragment instanceof WebViewFragment)
            ((WebViewFragment)fragment).handleBackPress();
        else if(fragment instanceof WPPostDetailsFragment)
            ((WPPostDetailsFragment)fragment).handleBackPress();
        else if(fragment instanceof WPPostFragment)
            ((WPPostFragment)fragment).handleBackPress();
        else super.onBackPressed();
    }



}